<?php
/**
 * Carbon Theme functions
 *
 * @package WordPress
 * @subpackage carbon
 */

if ( ! function_exists( 'carbon_setup' ) ) :
	/**
	 * Sets up theme defaults and registers the various WordPress features that
	 * this theme supports.
	 */
	function carbon_setup() {
		load_theme_textdomain( 'carbon' );
		add_theme_support( 'automatic-feed-links' );
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );

		// This theme allows users to set a custom background.
		add_theme_support(
			'custom-background',
			array(
				'default-color' => 'f5f5f5',
			)
		);

		add_theme_support( 'custom-logo' );
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 256,
				'width'       => 256,
				'flex-height' => true,
				'flex-width'  => true,
				'header-text' => array( 'site-title', 'site-description' ),
			)
		);
	}
endif; // end function_exists carbon_setup.

add_action( 'after_setup_theme', 'carbon_setup' );

remove_action( 'wp_head', '_custom_logo_header_styles' );

if ( ! is_admin() ) {
	add_action(
		'wp_enqueue_scripts',
		function() {
			wp_dequeue_style( 'global-styles' );
			wp_dequeue_style( 'classic-theme-styles' );
			wp_dequeue_style( 'wp-block-library' );
		}
	);
}

/**
 * Enqueue styles with a unique version number to force browser cache refresh.
 * This is crucial since we modified the style.css heavily.
 */
function carbon_enqueue_styles() {
    // Use a high version number to ensure the browser reloads the black/green stylesheet.
    wp_enqueue_style( 'carbon-style', get_stylesheet_uri(), array(), '1.0.0' );
}
add_action( 'wp_enqueue_scripts', 'carbon_enqueue_styles' );

/**
 * Registers customizer features.
 * The Static Front Page setting is now enabled (the code that disabled it was removed).
 *
 * @param class $wp_customize Customizer object.
 */
function carbon_customize_register( $wp_customize ) {
	// Static Front Page section is intentionally left enabled here.

	$wp_customize->add_section(
		'carbon_footer',
		array(
			'title'      => __( 'Footer', 'carbon' ),
			'priority'   => 120,
			'capability' => 'edit_theme_options',
			'panel'      => '',
		)
	);
	
	// Checkbox sanitization function
	function carbon_sanitize_checkbox( $checked ) {
		// Returns true if checkbox is checked.
		return ( ( isset( $checked ) && true === $checked ) ? true : false );
	}
	
	// Customizer settings for the footer are now removed for a clean look.
}
add_action( 'customize_register', 'carbon_customize_register', 100 );


/**
 * Overrides the site title ONLY for the browser tab.
 *
 * @param string $original_title The site title.
 * @return string The new site title.
 */
function carbon_title_override( $original_title ) {
    // FIX: Removed the space to make it "ComfyUI" as one word.
    return 'ComfyUI WordPress Plugin'; 
}
add_filter( 'pre_option_blogname', 'carbon_title_override' );