<?php
/**
 * The Header for the Carbon Theme.
 *
 * This file starts the HTML document, opens the body tag, and loads scripts via wp_head().
 * Includes the primary navigation placeholder.
 *
 * @package Carbon
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <!-- CRITICAL: Ensures the browser uses the device's actual width and prevents zooming -->
    <meta name="viewport" content="width=device-width, initial-scale=1.0, viewport-fit=cover">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<div id="page">
    <header id="site-header" class="site-header" role="banner">
        <div class="site-branding">
            <?php the_custom_logo(); ?>
            <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
        </div>
        
        <nav id="site-navigation" class="main-navigation">
            <?php
            wp_nav_menu( array(
                'theme_location' => 'primary', 
                'container_class' => 'menu-header',
                'menu_id' => 'primary-menu',
            ) );
            ?>
        </nav><!-- #site-navigation -->
    </header><!-- #site-header -->

    <div id="content-container">  <!-- Main layout container for centering content -->
    