<?php
/**
 * The main template file.
 *
 * This file is required for the theme to function. It serves as the fallback
 * template for all requests unless a more specific template is found.
 *
 * @package Carbon
 */

get_header();
?>

    <main id="primary" class="site-main">

        <?php
        if ( have_posts() ) :
            while ( have_posts() ) : the_post();
                ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <header class="entry-header">
                        <?php the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); ?>
                    </header><div class="entry-content">
                        <?php the_content(); ?>
                    </div></article><?php
            endwhile;
        else :
            // If no content exists
            ?>
            <section class="no-results not-found">
                <header class="page-header">
                    <h1 class="page-title"><?php esc_html_e( 'Nothing Found', 'carbon' ); ?></h1>
                </header><div class="page-content">
                    <p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'carbon' ); ?></p>
                    <?php get_search_form(); ?>
                </div></section><?php
        endif;
        ?>

    </main><?php
get_footer();